<?php defined('EM_ROOT') || exit('access denied!'); ?>

<style>
    /* 主内容区 */
    .main-content {
        flex: 1;
        padding: 20px;
    }

    .content-container {
        max-width: 800px;
        margin: 0 auto;
        padding: 0 15px;
    }

    .page-title {
        text-align: center;
        margin-bottom: 10px;
        font-size: 28px;
        color: #333;
        font-weight: 600;
    }

    .page-desc {
        text-align: center;
        color: #666;
        margin-bottom: 15px;
        font-size: 14px;
    }

    /* 查询卡片 */
    .query-card {
        background-color: #fff;
        border-radius: 10px;
        box-shadow: 0 5px 20px rgba(0, 0, 0, 0.08);
        padding: 30px;
        position: relative;
        overflow: hidden;
    }

    /* 装饰元素 */
    .query-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 4px;
        background: linear-gradient(90deg, #1E9FFF, #0FC6C2);
    }

    .query-form {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 20px;
        margin-bottom: 25px;
    }

    @media (max-width: 768px) {
        .query-form {
            grid-template-columns: 1fr;
        }
    }

    .form-group {
        margin-bottom: 0;
    }

    .form-group label {
        display: block;
        margin-bottom: 8px;
        color: #333;
        font-size: 14px;
        font-weight: 500;
    }

    .form-control {
        width: 100%;
        padding: 10px 14px;
        border: 1px solid #e6e6e6;
        border-radius: 4px;
        font-size: 14px;
        transition: border-color 0.3s;
    }

    .form-control:focus {
        border-color: #1E9FFF;
        outline: none;
        box-shadow: 0 0 0 2px rgba(30, 159, 255, 0.1);
    }

    .form-hint {
        margin-top: 5px;
        font-size: 12px;
        color: #999;
    }

    .form-actions {
        text-align: center;
        margin-top: 10px;
    }

    .query-btn {
        font-size: 16px;
        background-color: #1E9FFF;
        color: #fff;
        border: none;
        border-radius: 4px;
        cursor: pointer;
        transition: all 0.3s;
        letter-spacing: 0.5px;
    }

    .query-btn:hover {
        background-color: #0081ff;
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(30, 159, 255, 0.3);
    }

    /* 提示区域 */
    .tips-section {
        margin-top: 40px;
    }

    .tips-title {
        font-size: 16px;
        color: #333;
        margin-bottom: 15px;
        font-weight: 500;
        display: flex;
        align-items: center;
        gap: 8px;
    }

    .tips-list {
        background-color: #f0f7ff;
        border-left: 3px solid #1E9FFF;
        padding: 15px 20px;
        border-radius: 0 4px 4px 0;
    }

    .tips-item {
        display: flex;
        margin-bottom: 10px;
        font-size: 14px;
        color: #666;
    }

    .tips-item:last-child {
        margin-bottom: 0;
    }

    .tips-item i {
        color: #1E9FFF;
        margin-right: 8px;
        flex-shrink: 0;
        margin-top: 3px;
    }

    /* 底部样式 */
    .site-footer {
        background-color: #fff;
        padding: 20px 0;
        border-top: 1px solid #f2f2f2;
        margin-top: 50px;
    }

    .footer-container {
        max-width: 1200px;
        margin: 0 auto;
        padding: 0 15px;
        text-align: center;
        font-size: 12px;
        color: #999;
    }

    /* 结果弹窗样式 */
    .result-modal {
        display: none;
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background-color: rgba(0, 0, 0, 0.5);
        z-index: 1000;
        align-items: center;
        justify-content: center;
        padding: 20px;
    }

    .modal-content {
        background-color: #fff;
        border-radius: 8px;
        width: 100%;
        max-width: 600px;
        max-height: 90vh;
        overflow-y: auto;
        animation: modalIn 0.3s;
    }

    @keyframes modalIn {
        from {
            opacity: 0;
            transform: translateY(-30px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .modal-header {
        padding: 18px 20px;
        border-bottom: 1px solid #f2f2f2;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .modal-title {
        font-size: 18px;
        font-weight: 600;
        color: #333;
    }

    .close-modal {
        background: none;
        border: none;
        font-size: 20px;
        color: #999;
        cursor: pointer;
        transition: color 0.2s;
    }

    .close-modal:hover {
        color: #333;
    }

    .modal-body {
        padding: 20px;
    }

    .order-status {
        text-align: center;
        padding: 15px 0;
        margin-bottom: 20px;
        border-bottom: 1px dashed #f2f2f2;
    }

    .status-text {
        font-size: 20px;
        font-weight: 600;
        margin-bottom: 5px;
    }

    .status-desc {
        color: #666;
        font-size: 14px;
    }

    .order-details p {
        margin-bottom: 12px;
        font-size: 14px;
    }

    .detail-label {
        display: inline-block;
        width: 80px;
        color: #999;
    }

    .modal-footer {
        padding: 15px 20px;
        border-top: 1px solid #f2f2f2;
        text-align: right;
    }
</style>

<!-- 主内容区 -->
<main class="main-content">
    <div class="content-container">
        <h1 class="page-title">游客下单查询</h1>
        <p class="page-desc">本页面适用于未登录用户购买订单的查询</p>
        <!-- 查询卡片 -->
        <div class="query-card">
            <form class="layui-form" id="form">
                <div class="query-form">
                    <div class="form-group">
                        <label for="orderNumber">订单编号</label>
                        <input type="text" name="out_trade_no" placeholder="请输入订单编号" class="form-control layui-input">
                        <p class="form-hint">订单编号可在手机付款记录中查看</p>
                    </div>
                    <?php foreach($order_required as $val): ?>
                        <div class="form-group">
                            <label for="phone"><?= $val['name'] ?></label>
                            <input type="text" name="required[<?= $val['name'] ?>]" placeholder="请输入下单<?= $val['name'] ?>" class="form-control layui-input">
                            <p class="form-hint">请输入下单时填写的<?= $val['name'] ?></p>
                        </div>
                    <?php endforeach; ?>
                    <div class="form-group">
                        <label for="recipient">其他证明</label>
                        <input type="text" name="attach" placeholder="" class="form-control layui-input">
                        <p class="form-hint">下单时如有填写其他信息</p>
                    </div>
                </div>
                <input name="token" value="<?= LoginAuth::genToken() ?>" type="hidden"/>
                <div class="form-actions" style="display: block;">
                    <button type="sbumit" lay-submit lay-filter="submit" class="query-btn layui-btn">
                        <i class="fa fa-search" aria-hidden="true"></i> 立即查询
                    </button>
                </div>
            </form>
        </div>

        <!-- 提示区域 -->
        <div class="tips-section">
            <h3 class="tips-title">
                <i class="fa fa-info-circle" aria-hidden="true"></i>
                查询说明
            </h3>
            <div class="tips-list">
                <div class="tips-item">
                    <span>填写任意一个表单即可查询</span>
                </div>
                <div class="tips-item">
                    <span>如查询不到订单，请检查输入信息是否正确或联系客服咨询</span>
                </div>
            </div>
        </div>
    </div>
</main>

<script>
    layui.use(['table'], function(){
        var $ = layui.$;
        var form = layui.form;
        var upload = layui.upload;
        var element = layui.element;
        form.on('submit(submit)', function(data){
            var field = data.field; // 获取表单全部字段值
            console.log(field);
            var loadIndex = layer.load(2);
            $.ajax({
                type: "POST",
                url: "<?= EM_URL ?>/user/visitors.php?action=visitors_search_order_count&origin=local",
                data: field,
                dataType: "json",
                success: function (e) {
                    layer.close(loadIndex)
                    if(e.code == 200){
                        if(e.data.order_count > 0){
                            var searchJson = JSON.stringify(e.data._search);
                            var base64Search = btoa(unescape(encodeURIComponent(searchJson)));
                            var targetUrl = 'visitors.php?action=get_visitors_order&_search=' + base64Search;
                            window.location.href = targetUrl;
                        }else{
                            layer.msg('没有查找到任何订单');
                        }
                    }else{
                        layer.msg(e.msg)
                    }

                },
                error: function (xhr) {
                    layer.close(loadIndex)
                    layer.msg('出错啦~');
                }
            });
            return false; // 阻止默认 form 跳转
        });

    })

</script>

<script>
    $('#menu-order').addClass('open');
    $('#menu-order > ul').css('display', 'block');
    $('#menu-order > a > i.nav_right').attr('class', 'fa fa-angle-down nav_right');
    $('#menu-order-visitors').addClass('menu-current');
</script>