<?php
/*
Plugin Name: 商品类型【通用卡密】
Version: 1.0.2
Plugin URL:
Description: 创建通用卡密类型的商品，并管理与发货相关卡密库存。适合用于卡密可重复使用的商品类型
Author: 驳手
Author URL:
Ui: Layui
*/

defined('EM_ROOT') || exit('access denied!');

// 添加商品类型
function plugin_goods_general_type($goods, &$result){
    $goods['goods_type_all'][] = ['name' => '通用卡密（新）', 'value' => 'general'];
    $result = $goods;
}

// 展示商品列表的商品类型徽章
function plugin_goods_list_type_general($type){
    echo <<<html
{{#  if(d.type == 'general'){ }}
<span class="layui-badge layui-bg-blue">新通用卡密</span>
{{#  } }}
html;
}

// 发货
function plugin_goods_general_deliver($db, $db_prefix, $goods, $order, $order_child){
    if($goods['type'] == 'general'){
        $sku = empty($order_child['sku']) ? '0' : $order_child['sku'];
        // 查询出库存表里的卡密
        $stock = $db->once_fetch_array("SELECT * FROM {$db_prefix}goods_general WHERE goods_id = {$order_child['goods_id']} AND sku = '{$sku}'");
        // 将查询出的卡密写入到发货表里
        $timestamp = time();
        $db->query("INSERT INTO {$db_prefix}goods_general_sale 
    (goods_id, order_list_id, sku, content, num, create_time) 
VALUES ({$order_child['goods_id']}, {$order_child['id']}, '{$sku}', '{$stock['content']}', {$order_child['quantity']}, $timestamp)");

        // 更新订单状态
        $db->query("UPDATE {$db_prefix}order SET status = 2 WHERE id = '{$order['id']}'");
    }
}

// 未售库存页面
function plugin_goods_general_stock_ws($goods, &$result){
    if($goods['type'] == 'general'){
        $goods['stock_page'] = "../../content/plugins/goods_general/goods_general_show";
        $result = $goods;
    }

}
// 已售库存页面
function plugin_goods_general_stock_ys($goods, &$result){
    if($goods['type'] == 'general'){
        $goods['stock_page'] = "../../content/plugins/goods_general/goods_general_show";
        $result = $goods;
    }

}

// 订单列表按钮
function plugin_goods_general_user_order_list_btn($order, $child_order){
    if($child_order['type'] == 'general'){
        if(!empty($order['pay_time'])){
            echo <<<html
<a href="?action=sdk&out_trade_no={$order['out_trade_no']}" class="layui-btn">
    查看卡密信息
</a>
<a href="{$child_order['url']}" target="_blank" class="layui-btn layui-bg-cyan">再次购买</a>
html;

        }
    }
}

function plugin_goods_general_get_order_serect($db, $db_prefix, $goods, $order, $child_order, $limit){
    $sql = "select * from {$db_prefix}goods_general_sale where order_list_id = {$child_order['id']} order by id asc";
    if(!empty($limit)){
        $sql .= " limit {$limit}";
    }
    $kami = $db->fetch_all($sql);
    $sql = "select count(id) res_count from {$db_prefix}goods_general_sale where order_list_id = {$child_order['id']}";
    $res = $db->once_fetch_array($sql);
    return [
        'count' => $res['res_count'],
        'list' => $kami
    ];
}


// 显示订单详情页
function plugin_goods_general_view_order_detail($db, $db_prefix, $goods, $order, $child_order){
    if($goods['type'] == 'general'){
        $kami = $db->once_fetch_array("select * from {$db_prefix}goods_general_sale where order_list_id = {$child_order['id']}");

        include View::getUserView('_header');
        include EM_ROOT . "/content/plugins/goods_general/order_detail.php";
        include View::getUserView('_footer');
        View::output();
    }
}


// 获取发货内容
function plugin_goods_general_adm_order_detail($db, $db_prefix, $goods, $child_order){

    if($goods['type'] == 'general'){
        $sale = $db->once_fetch_array("select * from {$db_prefix}goods_general_sale where order_list_id = {$child_order['id']}");
        return  empty($sale) ? '无' : $sale['content'];
    }
}

function plugin_goods_general_home_goods_list($goods, &$result){
    foreach($goods as $key => $val){
        if($val['type'] == 'general'){
            $goods[$key]['type_text_badge'] = '<span class="badge badge-success">自动发货</span>';
        }
    }
    $result = $goods;
}

function plugin_goods_general_goods_content_echo($goods, &$result){
    if($goods['type'] == 'general'){
        $goods['type_text_badge'] = '<span class="badge badge-success">自动发货</span>';
    }
    $result = $goods;
}

addAction('adm_add_goods_goodsinfo', 'plugin_goods_general_type');
addAction('adm_goods_list_type', 'plugin_goods_list_type_general');
addAction('adm_stock_page_ws', 'plugin_goods_general_stock_ws');
addAction('adm_stock_page_ys', 'plugin_goods_general_stock_ys');
addAction('deliver', 'plugin_goods_general_deliver');
addAction('user_order_list_btn', 'plugin_goods_general_user_order_list_btn');
addAction('view_order_detail', 'plugin_goods_general_view_order_detail');
addAction('home_goods_list', 'plugin_goods_general_home_goods_list');
addAction('goods_content_echo', 'plugin_goods_general_goods_content_echo');