<?php
defined('EM_ROOT') || exit('access denied!');
?>
<style>
    /* 主内容区样式 */
    .main-content {
        padding: 20px 15px;
    }

    .page-title {
        margin-bottom: 25px;
        font-size: 24px;
        font-weight: 600;
        color: #333;
    }

    /* 卡片通用样式 */
    .card {
        background-color: #fff;
        border-radius: 8px;
        box-shadow: 0 2px 12px rgba(0, 0, 0, 0.06);
        padding: 20px;
        margin-bottom: 20px;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
    }

    .card:hover {
        transform: translateY(-3px);
        box-shadow: 0 4px 16px rgba(0, 0, 0, 0.1);
    }

    .card-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 15px;
        padding-bottom: 10px;
        border-bottom: 1px solid #f2f3f5;
    }

    .card-title {
        font-size: 18px;
        font-weight: 600;
        color: #333;
    }

    /* 余额卡片样式 */
    .balance-card {
        text-align: center;
        background: linear-gradient(135deg, #1E9FFF 0%, #0066CC 100%);
        color: #fff;
        padding: 30px 20px;
    }

    .balance-title {
        font-size: 16px;
        opacity: 0.9;
        margin-bottom: 15px;
    }

    .balance-amount {
        font-size: 36px;
        font-weight: 700;
        margin-bottom: 20px;
        letter-spacing: 1px;
    }

    .balance-actions {
        display: flex;
        justify-content: center;
        gap: 15px;
    }

    .balance-btn {
        background-color: rgba(255, 255, 255, 0.2);
        color: #fff;
        border: none;
        padding: 8px 20px;
        border-radius: 20px;
        cursor: pointer;
        transition: all 0.3s ease;
        display: flex;
        align-items: center;
        gap: 5px;
    }

    .balance-btn:hover {
        background-color: rgba(255, 255, 255, 0.3);
        transform: translateY(-2px);
    }

    /* 资产卡片样式 */
    .assets-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
        gap: 20px;
        margin-bottom: 30px;
    }

    .asset-item {
        display: flex;
        flex-direction: column;
        align-items: center;
        padding: 20px;
    }

    .asset-icon {
        width: 50px;
        height: 50px;
        border-radius: 50%;
        background-color: #f0f7ff;
        display: flex;
        align-items: center;
        justify-content: center;
        margin-bottom: 15px;
        font-size: 22px;
        color: #1E9FFF;
    }

    .asset-name {
        font-size: 14px;
        color: #666;
        margin-bottom: 5px;
    }

    .asset-value {
        font-size: 18px;
        font-weight: 600;
        color: #333;
    }

    /* 图表容器 */
    .chart-container {
        height: 300px;
        position: relative;
    }

    /* 交易记录样式 */


    .transaction-item {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 15px 0;
        border-bottom: 1px solid #f2f3f5;
    }

    .transaction-item:last-child {
        border-bottom: none;
    }

    .transaction-info {
        display: flex;
        align-items: center;
        gap: 15px;
    }

    .transaction-icon {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 16px;
    }

    .income-icon {
        background-color: #f0fff4;
        color: #00B42A;
    }

    .expense-icon {
        background-color: #fff0f0;
        color: #F53F3F;
    }

    .transaction-details {
        display: flex;
        flex-direction: column;
    }

    .transaction-title {
        font-weight: 500;
        color: #333;
    }

    .transaction-time {
        font-size: 12px;
        color: #999;
    }

    .transaction-amount {
        font-weight: 600;
    }

    .income {
        color: #00B42A;
    }

    .expense {
        color: #F53F3F;
    }

    /* 响应式调整 */
    @media (max-width: 768px) {
        .balance-amount {
            font-size: 28px;
        }

        .page-title {
            font-size: 20px;
        }

        .card {
            padding: 15px;
        }

        .chart-container {
            height: 250px;
        }

        .assets-grid {
            grid-template-columns: 1fr 1fr;
        }
    }

    @media (max-width: 480px) {
        .balance-actions {
            flex-direction: column;
            width: 100%;
        }

        .balance-btn {
            width: 100%;
            justify-content: center;
        }

        .assets-grid {
            grid-template-columns: 1fr;
        }

        .transaction-title {
            font-size: 14px;
        }
    }
</style>

<!-- 主内容区 -->
<main class="main-content">
    <div class="">
        <!-- 余额卡片 -->
        <div class="card balance-card">
            <div class="balance-title">当前可用余额</div>
            <div class="balance-amount">¥ <?= $user['money'] ?></div>
            <div class="balance-actions">
                <button class="balance-btn">
                    充值余额请联系网站客服
                </button>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <div class="card-title">最近交易</div>
                <a href="javascript:;" class="layui-text layui-btn layui-btn-primary layui-btn-xs">
                    仅显示最近10条交易记录
                </a>
            </div>
            <div class="transaction-list">
                <?php foreach($log as $val): ?>
                <div class="transaction-item">
                    <div class="transaction-info">

                        <?php if($val['plus'] == 'y'): ?>
                            <div class="transaction-icon income-icon">
                                <i class="fa fa-arrow-down" aria-hidden="true"></i>
                            </div>
                        <?php else: ?>
                            <div class="transaction-icon expense-icon">
                                <i class="fa fa-arrow-up" aria-hidden="true"></i>
                            </div>
                        <?php endif; ?>
                        <div class="transaction-details">
                            <div class="transaction-title"><?= $val['description'] ?></div>
                            <div class="transaction-time"><?= date('Y-m-d H:i:s', $val['create_time']) ?></div>
                        </div>
                    </div>
                    <?php if($val['plus'] == 'y'): ?>
                    <div class="transaction-amount income">+¥<?= $val['money'] ?></div>
                    <?php else: ?>
                        <div class="transaction-amount expense">-¥<?= $val['money'] ?></div>
                    <?php endif; ?>
                </div>
                <?php endforeach; ?>

            </div>
        </div>

    </div>
</main>


<script>
    // 初始化Layui模块
    layui.use(['element', 'layer'], function() {
        var element = layui.element;
        var layer = layui.layer;


    });
</script>

<script>
    $(function () {
        $('#menu-balance').addClass('open menu-current');
    });
</script>
