<?php
/**
 * store
 */

/**
 * @var string $action
 * @var object $CACHE
 */

require_once 'globals.php';

$Store_Model = new Store_Model();


$plugin_type_arr = [
    ['id' => 0, 'title' => '全部插件'],
    ['id' => 1, 'title' => '支付方式'],
    ['id' => 7, 'title' => '商品类型扩展'],
    ['id' => 2, 'title' => '系统通知'],
    ['id' => 3, 'title' => '页面美化'],
    ['id' => 4, 'title' => '系统扩展'],
    ['id' => 6, 'title' => '客服组件'],
    ['id' => 5, 'title' => '未归类'],
];

if (empty($action)) {
    $br = '<a href="./">控制台</a><a href="./store.php">应用商店</a><a><cite>全部应用</cite></a>';

    $db = Database::getInstance();
    $db_prefix = DB_PREFIX;
    $domain = getDomain();
    $sql = "select * from {$db_prefix}authorization where domain='{$domain}'";
    $res = $db->once_fetch_array($sql);
    $emkey =  empty($res) ? 'em' : $res['emkey'];

    include View::getAdmView('header');
    require_once(View::getAdmView('store'));
    include View::getAdmView('footer');
    View::output();
}
if ($action === 'plu') {
    $br = '<a href="./">控制台</a><a href="./store.php">应用商店</a><a><cite>扩展插件</cite></a>';

    $db = Database::getInstance();
    $db_prefix = DB_PREFIX;
    $domain = getDomain();
    $sql = "select * from {$db_prefix}authorization where domain='{$domain}'";
    $res = $db->once_fetch_array($sql);
    $emkey =  empty($res) ? 'em' : $res['emkey'];

    $plugin_type = Input::getStrVar('plugin_type', 0);
    $title = Input::getStrVar('title');
    include View::getAdmView('header');
    require_once(View::getAdmView('store_plu'));
    include View::getAdmView('footer');
    View::output();
}
if ($action === 'tpl') {
    $br = '<a href="./">控制台</a><a href="./store.php">应用商店</a><a><cite>模板主题</cite></a>';

    $db = Database::getInstance();
    $db_prefix = DB_PREFIX;
    $domain = getDomain();
    $sql = "select * from {$db_prefix}authorization where domain='{$domain}'";
    $res = $db->once_fetch_array($sql);
    $emkey =  empty($res) ? 'em' : $res['emkey'];

    include View::getAdmView('header');
    require_once(View::getAdmView('store_tpl'));
    include View::getAdmView('footer');
    View::output();
}

if($action == 'index'){
    $tag = Input::getStrVar('tag');
    $page = Input::getIntVar('page', 1);
    $keyword = Input::getStrVar('keyword');
    $author_id = Input::getStrVar('author_id');
    $sid = Input::getStrVar('sid');

    $r = $Store_Model->getApps($tag, $keyword, $page, $author_id, $sid);

    $Plugin_Model = new Plugin_Model();
    $p = $Plugin_Model->getPlugins();
    $install_plugin = [];
    foreach($p as $val){
        $install_plugin[] = $val['Plugin'];
    }

    $Template_Model = new Template_Model();
    $p = $Template_Model->getTemplates();
    foreach($p as $val){
        $install_plugin[] = $val['tplfile'];
    }

    $apps = $r['apps'];
    $count = $r['count'];
    $page_count = $r['page_count'];

    $reg_type = Register::getRegType();

    foreach($apps as $key => $val){
        $apps[$key]['reg_type'] = $reg_type;
        if(in_array($val['english_name'], $install_plugin)){
            $apps[$key]['is_install'] = 'y';
        }else{
            $apps[$key]['is_install'] = 'n';
        }
    }


    output::data($apps, $count);
}

if($action == 'tpl_ajax'){
    $tag = Input::getStrVar('tag');
    $page = Input::getIntVar('page', 1);
    $keyword = Input::getStrVar('keyword');
    $author_id = Input::getStrVar('author_id');
    $sid = Input::getStrVar('sid');

    $r = $Store_Model->getTemplates($tag, $keyword, $page, $author_id, $sid);

    $Plugin_Model = new Plugin_Model();
    $p = $Plugin_Model->getPlugins();
    $install_plugin = [];
    foreach($p as $val){
        $install_plugin[] = $val['Plugin'];
    }

    $Template_Model = new Template_Model();
    $p = $Template_Model->getTemplates();
    foreach($p as $val){
        $install_plugin[] = $val['tplfile'];
    }

    $apps = $r['templates'];
    $count = $r['count'];
    $page_count = $r['page_count'];

    $reg_type = Register::getRegType();

    foreach($apps as $key => $val){
        $apps[$key]['reg_type'] = $reg_type;
        if(in_array($val['english_name'], $install_plugin)){
            $apps[$key]['is_install'] = 'y';
        }else{
            $apps[$key]['is_install'] = 'n';
        }
    }

    output::data($apps, $count);
}



if($action == 'plu_ajax'){
    $tag = Input::getStrVar('tag');
    $page = Input::getIntVar('page', 1);
    $keyword = Input::getStrVar('keyword');
    $author_id = Input::getStrVar('author_id');
    $sid = Input::getStrVar('sid');

    $plugin_type = Input::getStrVar('plugin_type', 0);

    $r = $Store_Model->getPlugins($tag, $keyword, $page, $author_id, $plugin_type);
//    echo 1;die;
    $Plugin_Model = new Plugin_Model();
    $p = $Plugin_Model->getPlugins();
    $install_plugin = [];
    foreach($p as $val){
        $install_plugin[] = $val['Plugin'];
    }

    $Template_Model = new Template_Model();
    $p = $Template_Model->getTemplates();
    foreach($p as $val){
        $install_plugin[] = $val['tplfile'];
    }

    $apps = $r['plugins'];
    $count = $r['count'];
    $page_count = $r['page_count'];

    $reg_type = Register::getRegType();

    foreach($apps as $key => $val){
        $apps[$key]['reg_type'] = $reg_type;
        if(in_array($val['english_name'], $install_plugin)){
            $apps[$key]['is_install'] = 'y';
        }else{
            $apps[$key]['is_install'] = 'n';
        }
    }

    output::data($apps, $count);
}



if ($action === 'mine') {
    $addons = $Store_Model->getMyAddon();
    $sub_title = '我的已购';

    include View::getAdmView('header');
    require_once(View::getAdmView('store_mine'));
    include View::getAdmView('footer');
    View::output();
}

if ($action === 'svip') {
    $addons = $Store_Model->getSvipAddon();
    $sub_title = '铁杆专属';

    include View::getAdmView('header');
    require_once(View::getAdmView('store_svip'));
    include View::getAdmView('footer');
    View::output();
}

if ($action === 'top') {
    $addons = $Store_Model->getTopAddon();
    output::ok($addons);
}

if ($action === 'error') {
    $keyword = '';
    $sub_title = '';
    $sid = '';

    $br = '<ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="./">控制台</a></li>
        <li class="breadcrumb-item"><a href="./store.php">应用商店</a></li>
        <li class="breadcrumb-item active" aria-current="page">全部应用</li>
    </ol>';

    include View::getAdmView('header');
    require_once(View::getAdmView('store'));
    include View::getAdmView('footer');
    View::output();
}

if ($action === 'install') {
    $source = isset($_POST['source']) ? trim($_POST['source']) : ''; // plugin/down/11
    $cdn_source = isset($_POST['cdn_source']) ? trim($_POST['cdn_source']) : '';
    $source_type = isset($_POST['type']) ? trim($_POST['type']) : '';

    if (empty($source)) {
        output::error('安装失败，插件文件源无效');
    }

    if (false == Register::verifyDownload($source)) {
        output::error(SERVICE_NAME . '未授权，<a href="auth.php">去授权</a>');
    }



    if ($cdn_source) {
        $temp_file = emFetchFile($cdn_source);
    } else {
        $temp_file = emFetchFile(SERVICE_HOST . '/' . $source);
    }
    if (!$temp_file) {
        output::error('安装失败，下载超时或没有权限');
    }

    if ($source_type == 'tpl') {
        $unzip_path = '../content/templates/';
        $store_path = './store.php?';
        $suc_url = 'template.php';
    } else {
        $unzip_path = '../content/plugins/';
        $store_path = './store.php?action=plu&';
        $suc_url = 'plugin.php';
    }

    $ret = emUnZip($temp_file, $unzip_path, $source_type);
    @unlink($temp_file);
    switch ($ret) {
        case 0:
            output::ok('安装成功 <a href="' . $suc_url . '">去启用</a>');
        case 1:
        case 2:
        output::error('安装失败，请检查content下目录是否可写');
        case 3:
            output::error('安装失败，请安装php的Zip扩展');
        default:
            output::error('安装失败，不是有效的安装包');
    }
}
