<?php defined('EM_ROOT') || exit('access denied!'); ?>
<style>
    body {
        background: #f8f9fa;
        min-height: 100vh;
        display: flex;
        align-items: center;
        justify-content: center;
        padding: 20px;
    }
    .card {
        border-radius: 15px;
        box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        border: none;
        transition: all 0.3s ease;
    }
    .card:hover {
        box-shadow: 0 15px 35px rgba(0,0,0,0.15);
    }
    .card-header {
        background: linear-gradient(135deg, #3B82F6, #2563EB);
        color: white;
        border-radius: 15px 15px 0 0 !important;
        padding: 20px;
        text-align: center;
        font-size: 24px;
        font-weight: 600;
    }
    .form-control {
        border-radius: 8px;
        padding: 12px 15px;
        border: 1px solid #e2e8f0;
        transition: border-color 0.2s, box-shadow 0.2s;
    }
    .form-control:focus {
        border-color: #3B82F6;
        box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.3);
        outline: none;
    }
    .btn-primary {
        background: linear-gradient(135deg, #3B82F6, #2563EB);
        border: none;
        border-radius: 8px;
        padding: 12px;
        font-size: 18px;
        font-weight: 500;
        transition: all 0.3s ease;
    }
    .btn-primary:hover {
        background: linear-gradient(135deg, #2563EB, #1D4ED8);
        transform: translateY(-2px);
    }
    .btn-primary:active {
        transform: translateY(0);
    }
    .alert {
        border-radius: 8px;
        padding: 12px 15px;
        margin-bottom: 20px;
    }
    .login-links {
        display: flex;
        justify-content: center;
        gap: 20px;
        margin-top: 20px;
    }
    .login-links a {
        color: #64748B;
        text-decoration: none;
        transition: color 0.2s;
    }
    .login-links a:hover {
        color: #3B82F6;
        text-decoration: underline;
    }
</style>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-xl-5 col-lg-6 col-md-8 col-sm-8 col-12">
            <div class="card">
                <div class="card-header">
                    <i class="fa fa-key mr-2"></i>重置密码
                </div>
                <div class="card-body p-5">
                    <!-- 提示信息 -->
                    <?php if (isset($_GET['succ_mail'])): ?>
                        <div class="alert alert-success alert-dismissible fade show">
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                            <i class="fa fa-check-circle mr-2"></i>邮件验证码已发送到你的邮箱，请查收后填写
                        </div>
                    <?php endif ?>

                    <?php if (isset($_GET['err_mail_code'])): ?>
                        <div class="alert alert-danger alert-dismissible fade show">
                            <button type="button" class="close" data-dismiss="alert">&times;</button>
                            <i class="fa fa-exclamation-circle mr-2"></i>邮件验证码错误
                        </div>
                    <?php endif ?>

                    <form method="post" class="user" action="./account.php?action=doreset2">
                        <div class="form-group">
                            <label for="mail_code" class="sr-only">邮件验证码</label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><i class="fa fa-envelope-open"></i></span>
                                </div>
                                <input type="text" class="form-control" id="mail_code" name="mail_code" placeholder="邮件验证码(请查收邮件)" required>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="passwd" class="sr-only">新的密码</label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><i class="fa fa-lock"></i></span>
                                </div>
                                <input type="password" class="form-control" minlength="6" id="passwd" autocomplete="new-password" name="passwd" placeholder="新的密码" required>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="repasswd" class="sr-only">确认新密码</label>
                            <div class="input-group">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><i class="fa fa-lock"></i></span>
                                </div>
                                <input type="password" class="form-control" minlength="6" id="repasswd" name="repasswd" placeholder="确认新密码" required>
                            </div>
                        </div>

                        <button type="submit" class="btn btn-primary btn-block">
                            <i class="fa fa-refresh mr-2"></i>重置密码
                        </button>

                        <hr class="my-4">

                        <div class="text-center mt-4">
                            <a href="./" class="text-primary">
                                <i class="fa fa-sign-in mr-1"></i>返回登录
                            </a>
                        </div>

                        <hr class="my-4">

                        <div class="login-links">
                            <a href="../" class="text-muted">
                                <i class="fa fa-home mr-1"></i>返回首页
                            </a>
                            <a href="./account.php?action=signup" class="text-muted">
                                <i class="fa fa-user-plus mr-1"></i>注册新账号
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
</body>
</html>
<script>
    $(function () {
        setTimeout(hideActived, 6000);
    });
</script>