<?php

const EM_ROOT = __DIR__;

require_once EM_ROOT . '/include/lib/common.php';
require_once EM_ROOT . '/base.php';
header('Content-Type: text/html; charset=UTF-8');
spl_autoload_register("emAutoload");

//var_dump(PHP_VERSION);

if (PHP_VERSION < '7.4') {
    emMsg('PHP版本太低，推荐使用PHP7.4及以上版本');
}

$act = Input::getStrVar('action');

$bt_db_host = 'localhost';
$bt_db_username = 'BT_DB_USERNAME';
$bt_db_password = 'BT_DB_PASSWORD';
$bt_db_name = 'BT_DB_NAME';

$env_em_env = getenv('EM_ENV');
$env_db_host = getenv('EM_DB_HOST');
$env_db_name = getenv('EM_DB_NAME');
$env_db_user = getenv('EM_DB_USER');
$env_db_password = getenv('EM_DB_PASSWORD');

$service_name = SERVICE_NAME;
$service_host = SERVICE_HOST;
$timestamp = time();

if (!$act) {
    ?>
    <!doctype html>
    <html lang="zh-cn">

    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge, chrome=1">
        <meta name="renderer" content="webkit">
        <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
        <meta name="applicable-device" content="pc,mobile">

        <title><?= SERVICE_NAME ?>在线安装程序</title>

        <link rel="stylesheet" href="./admin/views/layui-v2.11.6/layui/css/layui.css">
        <script src="./admin/views/layui-v2.11.6/layui/layui.js"></script>
        <link rel="stylesheet" href="./admin/views/css/style.css">
        <link rel="stylesheet" href="./content/static/css/install.css">

        <style>
            body{
                /* 角度渐变（45度方向） */
                background: linear-gradient(45deg, #25936b, #ffb933);
            }
            .form-tips{
                color: #00463b;
            }
            .bg-logo {
                width: 100%;
                font-size: 20rem;
                position: fixed;
                left: 50%;
                top: 50%;
                transform: translate(-50%, -50%);
                text-align: center;
                line-height: 1;
                color: #fff;
                opacity: 10%;
            }
            @media (max-width: 1500px) {
                .bg-logo {
                    font-size: 15rem;
                }
            }
            @media (max-width: 1200px) {
                .bg-logo {
                    font-size: 14rem;
                }
            }
            @media (max-width: 1000px) {
                .bg-logo {
                    font-size: 12rem;
                }
            }
            @media (max-width: 900px) {
                .bg-logo {
                    font-size: 8rem;
                }
            }
            @media (max-width: 700px) {
                .bg-logo {
                    font-size: 5rem;
                }
            }
            .layui-form-label{
                font-size: 15px;
            }
            /* 取消输入框自动填充的背景色 */
            input:-webkit-autofill,
            input:-webkit-autofill:hover,
            input:-webkit-autofill:focus,
            input:-webkit-autofill:active {
                /* 覆盖默认的黄色背景 */
                -webkit-box-shadow: 0 0 0 1000px transparent inset !important;
                /* 保持文字颜色（可选） */
                -webkit-text-fill-color: #333 !important;
                /* 背景色透明（可选，配合上面的阴影效果） */
                background-color: transparent !important;
                /* 延长自动填充样式的生效时间（部分浏览器需要） */
                transition: background-color 5000s ease-in-out 0s !important;
            }
        </style>

    </head>

    <body>
    <div class="bg-logo">EMSHOP</div>
    <form class="layui-form" id="form" method="post" action="install.php?action=install">
        <p class="title mb20" style="padding-bottom: 20px;"><?= SERVICE_NAME ?> 版本v<?= Option::EM_VERSION ?></p>
        <?php if ($env_db_user): ?>
            <div class="b">
                <input name="hostname" type="hidden" value="<?= $env_db_host ?>">
                <input name="dbuser" type="hidden" value="<?= $env_db_user ?>">
                <input name="dbpasswd" type="hidden" value="<?= $env_db_password ?>">
                <input name="dbname" type="hidden" value="<?= $env_db_name ?>">
                <input name="dbprefix" type="hidden" value="em_">
            </div>
        <?php elseif (strpos($bt_db_username, 'BT_DB_') === false): ?>
            <div class="b">
                <input name="hostname" type="hidden" value="<?= $bt_db_host ?>">
                <input name="dbuser" type="hidden" value="<?= $bt_db_username ?>">
                <input name="dbpasswd" type="hidden" value="<?= $bt_db_password ?>">
                <input name="dbname" type="hidden" value="<?= $bt_db_name ?>">
                <input name="dbprefix" type="hidden" value="em_">
            </div>
        <?php else: ?>
            <div class="layui-card">
                <div class="layui-card-header" style="padding: 20px 20px;">
                    <span class="" style="font-size: 16px; font-weight: bold;">数据库配置</span>
                </div>
                <div class="layui-card-body">
                    <div class="layui-form-item">
                        <label class="layui-form-label">数据库地址</label>
                        <div class="layui-input-block">
                            <input type="text" name="hostname" class="layui-input" value="localhost">
                            <div class="form-tips">通常为 localhost 或者指定端口 localhost:3306</div>
                        </div>
                    </div>
                    <div class="layui-form-item">
                        <label class="layui-form-label">数据库名</label>
                        <div class="layui-input-block">
                            <input type="text" name="dbname" class="layui-input" value="">
                            <div class="form-tips">程序不会自动创建数据库，请提前创建一个空数据库或使用已有数据库</div>
                        </div>
                    </div>
                    <div class="layui-form-item">
                        <label class="layui-form-label">数据库用户名</label>
                        <div class="layui-input-block">
                            <input type="text" name="dbuser" class="layui-input" value="">
                        </div>
                    </div>
                    <div class="layui-form-item">
                        <label class="layui-form-label">数据库密码</label>
                        <div class="layui-input-block">
                            <input type="password" name="dbpasswd" class="layui-input" value="">
                        </div>
                    </div>
                    <div class="layui-form-item">
                        <label class="layui-form-label">数据表前缀</label>
                        <div class="layui-input-block">
                            <input type="text" name="dbprefix" class="layui-input" value="em_">
                            <div class="form-tips">通常默认即可，不必修改。由英文字母、数字、下划线组成，且必须以下划线结束</div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
        <div class="layui-card">
            <div class="layui-card-header" style="padding: 20px 20px;">
                <span class="" style="font-size: 16px; font-weight: bold;">管理员配置</span>
            </div>
            <div class="layui-card-body">
                <div class="layui-form-item">
                    <label class="layui-form-label">登录账号</label>
                    <div class="layui-input-block">
                        <input type="text" name="username" class="layui-input" value="admin">
                    </div>
                </div>
                <div class="layui-form-item">
                    <label class="layui-form-label">登录密码</label>
                    <div class="layui-input-block">
                        <input type="password" name="password" class="layui-input" value="">
                    </div>
                </div>
                <div class="layui-form-item">
                    <label class="layui-form-label">确认密码</label>
                    <div class="layui-input-block">
                        <input type="password" name="repassword" class="layui-input" value="">
                    </div>
                </div>
                <div class="layui-form-item">
                    <label class="layui-form-label">管理员邮箱</label>
                    <div class="layui-input-block">
                        <input type="email" name="email" class="layui-input" value="">
                    </div>
                </div>
            </div>
        </div>
        <div style="text-align: center; ">
            <button type="submit" class="layui-btn" style="margin: 0 auto; padding: 10px 60px;">开始安装</button>
        </div>
    </form>


    </body>

    </html>
    <?php
}
if ($act == 'install' || $act == 'reinstall' || $act == 'reinstall_mysql' || $act == 'reinstall_php') {
    $db_host = Input::postStrVar('hostname');
    $db_user = Input::postStrVar('dbuser');
    $db_pw = Input::postStrVar('dbpasswd');
    $db_name = Input::postStrVar('dbname');
    $db_prefix = Input::postStrVar('dbprefix');
    $username = Input::postStrVar('username');
    $password = Input::postStrVar('password');
    $repassword = Input::postStrVar('repassword');
    $email = Input::postStrVar('email');

    if ($db_prefix === '') {
        emMsg('数据库表前缀不能为空!');
    } elseif (!preg_match("/^[\w_]+_$/", $db_prefix)) {
        emMsg('数据库表前缀格式错误!');
    } elseif (!$username || !$password) {
        emMsg('登录名和密码不能为空!');
    } elseif (strlen($password) < 6) {
        emMsg('登录密码不得小于6位');
    } elseif ($password != $repassword) {
        emMsg('两次输入的密码不一致');
    }

    define('DB_HOST', $db_host);
    define('DB_USER', $db_user);
    define('DB_PASSWD', $db_pw);
    define('DB_NAME', $db_name);
    define('DB_PREFIX', $db_prefix);

    $DB = Database::getInstance();
    $CACHE = Cache::getInstance();

    $mysql_res = $DB->once_fetch_array("SELECT VERSION() AS mysql_version");
    if($act == 'install' && !empty($mysql_res) && ($mysql_res['mysql_version'] > '5.6.99' || $mysql_res['mysql_version'] < '5.6')){
        echo <<<EOT
<html>
<head>
<meta charset="utf-8">
<title><?= SERVICE_NAME ?></title>
<style>
body {background-color:#F7F7F7;font-family: Arial;font-size: 12px;line-height:150%;}
.main {background-color:#FFFFFF;font-size: 12px;color: #666666;width:750px;margin:10px auto;padding:10px;list-style:none;border:#DFDFDF 1px solid;}
.main p {line-height: 18px;margin: 5px 20px;}
</style>
</head><body>
<form name="form1" method="post" action="install.php?action=reinstall_mysql">
<div class="main">
    <input name="hostname" type="hidden" class="input" value="$db_host">
    <input name="dbuser" type="hidden" class="input" value="$db_user">
    <input name="dbpasswd" type="hidden" class="input" value="$db_pw">
    <input name="dbname" type="hidden" class="input" value="$db_name">
    <input name="dbprefix" type="hidden" class="input" value="$db_prefix">
    <input name="username" type="hidden" class="input" value="$username">
    <input name="password" type="hidden" class="input" value="$password">
    <input name="repassword" type="hidden" class="input" value="$repassword">
    <input name="email" type="hidden" class="input" value="$email">
<p>
你当前MySQL版本是：{$mysql_res['mysql_version']} 建议使用MySQL5.6系列的版本 确定强制安装吗？
<input type="submit" value="强制安装 &raquo;">
</p>
<p><a href="javascript:history.back(-1);">&laquo;点击返回</a></p>
</div>
</form>
</body>
</html>
EOT;
        exit;
    }


    $php_version = PHP_VERSION;
    if(($act == 'install' || $act == 'reinstall_mysql') && $php_version > '7.5'){
        echo <<<EOT
<html>
<head>
<meta charset="utf-8">
<title><?= SERVICE_NAME ?></title>
<style>
body {background-color:#F7F7F7;font-family: Arial;font-size: 12px;line-height:150%;}
.main {background-color:#FFFFFF;font-size: 12px;color: #666666;width:750px;margin:10px auto;padding:10px;list-style:none;border:#DFDFDF 1px solid;}
.main p {line-height: 18px;margin: 5px 20px;}
</style>
</head><body>
<form name="form1" method="post" action="install.php?action=reinstall_php">
<div class="main">
    <input name="hostname" type="hidden" class="input" value="$db_host">
    <input name="dbuser" type="hidden" class="input" value="$db_user">
    <input name="dbpasswd" type="hidden" class="input" value="$db_pw">
    <input name="dbname" type="hidden" class="input" value="$db_name">
    <input name="dbprefix" type="hidden" class="input" value="$db_prefix">
    <input name="username" type="hidden" class="input" value="$username">
    <input name="password" type="hidden" class="input" value="$password">
    <input name="repassword" type="hidden" class="input" value="$repassword">
    <input name="email" type="hidden" class="input" value="$email">
<p>
你当前PHP版本是：{$php_version} 建议使用PHP7.4 确定强制安装吗？
<input type="submit" value="强制安装 &raquo;">
</p>
<p><a href="javascript:history.back(-1);">&laquo;点击返回</a></p>
</div>
</form>
</body>
</html>
EOT;
        exit;
    }
    if ($act != 'reinstall' && $DB->num_rows($DB->query("SHOW TABLES LIKE '{$db_prefix}blog'")) == 1) {
        echo <<<EOT
<html>
<head>
<meta charset="utf-8">
<title><?= SERVICE_NAME ?></title>
<style>
body {background-color:#F7F7F7;font-family: Arial;font-size: 12px;line-height:150%;}
.main {background-color:#FFFFFF;font-size: 12px;color: #666666;width:750px;margin:10px auto;padding:10px;list-style:none;border:#DFDFDF 1px solid;}
.main p {line-height: 18px;margin: 5px 20px;}
</style>
</head><body>
<form name="form1" method="post" action="install.php?action=reinstall">
<div class="main">
    <input name="hostname" type="hidden" class="input" value="$db_host">
    <input name="dbuser" type="hidden" class="input" value="$db_user">
    <input name="dbpasswd" type="hidden" class="input" value="$db_pw">
    <input name="dbname" type="hidden" class="input" value="$db_name">
    <input name="dbprefix" type="hidden" class="input" value="$db_prefix">
    <input name="username" type="hidden" class="input" value="$username">
    <input name="password" type="hidden" class="input" value="$password">
    <input name="repassword" type="hidden" class="input" value="$repassword">
    <input name="email" type="hidden" class="input" value="$email">
<p>
你的<?= SERVICE_NAME ?>看起来已经安装过了。继续安装将会覆盖原有数据，确定要继续吗？
<input type="submit" value="继续&raquo;">
</p>
<p><a href="javascript:history.back(-1);">&laquo;点击返回</a></p>
</div>
</form>
</body>
</html>
EOT;
        exit;
    }else{
    }

    if (!is_writable('config.php')) {
        emMsg('配置文件(config.php)不可写，请调整文件读写权限。');
    }
    if (!is_writable(EM_ROOT . '/content/cache')) {
        emMsg('缓存目录（content/cache）不可写。请检查目录读写权限。');
    }

    $PHPASS = new PasswordHash(8, true);

    $config = "<?php\n"
        . "//MySQL database host\n"
        . "const DB_HOST = '$db_host';"
        . "\n//Database username\n"
        . "const DB_USER = '$db_user';"
        . "\n//Database user password\n"
        . "const DB_PASSWD = '$db_pw';"
        . "\n//Database name\n"
        . "const DB_NAME = '$db_name';"
        . "\n//Database Table Prefix\n"
        . "const DB_PREFIX = '$db_prefix';"
        . "\n//Auth key\n"
        . "const AUTH_KEY = '" . $PHPASS->HashPassword(getRandStr(32) . md5(getIp()) . getUA() . microtime()) . "';"
        . "\n//Cookie name\n"
        . "const AUTH_COOKIE_NAME = 'EM_AUTHCOOKIE_" . sha1(getRandStr(32, false) . md5(getIp()) . getUA() . microtime()) . "';";

    if (!file_put_contents('config.php', $config)) {
        emMsg('配置文件(config.php)不可写，请调整文件读写权限。');
    }

    $password = $PHPASS->HashPassword($password);

    $table_charset_sql = 'DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;';
    $DB->query("ALTER DATABASE `{$db_name}` DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;", true);

    $widget_title = serialize(Option::getWidgetTitle());
    $def_widgets = serialize(Option::getDefWidget());
    $def_plugin = serialize(Option::getDefPlugin());

    $apikey = md5(getRandStr(32));


    $em_url = realUrl();

    $sql = <<<sql
DROP TABLE IF EXISTS `{$db_prefix}attachment`;
CREATE TABLE `{$db_prefix}attachment`  (
  `aid` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '资源文件表',
  `alias` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '资源别名',
  `author` int(11) UNSIGNED NOT NULL DEFAULT 1 COMMENT '作者UID',
  `sortid` int(11) NOT NULL DEFAULT 0 COMMENT '分类ID',
  `blogid` int(11) UNSIGNED NOT NULL DEFAULT 0 COMMENT '文章ID（已废弃）',
  `filename` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '文件名',
  `filesize` int(11) NOT NULL DEFAULT 0 COMMENT '文件大小',
  `filepath` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '文件路径',
  `addtime` bigint(20) NOT NULL DEFAULT 0 COMMENT '创建时间',
  `width` int(11) NOT NULL DEFAULT 0 COMMENT '图片宽度',
  `height` int(11) NOT NULL DEFAULT 0 COMMENT '图片高度',
  `mimetype` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '文件mime类型',
  `thumfor` int(11) NOT NULL DEFAULT 0 COMMENT '缩略图的原资源ID（已废弃）',
  `download_count` bigint(20) UNSIGNED NOT NULL DEFAULT 0 COMMENT '下载次数',
  PRIMARY KEY (`aid`) USING BTREE,
  INDEX `thum_uid`(`thumfor`, `author`) USING BTREE,
  INDEX `addtime`(`addtime`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Compact;

DROP TABLE IF EXISTS `{$db_prefix}authorization`;
CREATE TABLE `{$db_prefix}authorization`  (
  `emkey` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `domain` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `type` tinyint(1) NULL DEFAULT 0
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Compact;

DROP TABLE IF EXISTS `{$db_prefix}discount`;
CREATE TABLE `{$db_prefix}discount`  (
  `goods_id` int(10) NOT NULL,
  `quantity` int(10) NULL DEFAULT NULL,
  `amount` int(10) NULL DEFAULT NULL
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Compact;

DROP TABLE IF EXISTS `{$db_prefix}stock_export_log`;
CREATE TABLE `{$db_prefix}stock_export_log`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `goods_id` int(10) NULL DEFAULT NULL,
  `filename` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `create_time` bigint(16) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 9 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Compact;

DROP TABLE IF EXISTS `{$db_prefix}blog`;
CREATE TABLE `{$db_prefix}blog`  (
  `gid` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '文章表',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '文章标题',
  `date` bigint(20) NOT NULL COMMENT '发布时间',
  `content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '文章内容',
  `excerpt` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '文章摘要',
  `cover` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '封面图',
  `alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '文章别名',
  `author` int(11) NOT NULL DEFAULT 1 COMMENT '作者UID',
  `sortid` int(11) NOT NULL DEFAULT -1 COMMENT '分类ID',
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'blog' COMMENT '文章OR页面',
  `views` int(11) UNSIGNED NOT NULL DEFAULT 0 COMMENT '阅读量',
  `comnum` int(11) UNSIGNED NOT NULL DEFAULT 0 COMMENT '评论数量',
  `attnum` int(11) UNSIGNED NOT NULL DEFAULT 0 COMMENT '附件数量（已废弃）',
  `top` enum('n','y') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n' COMMENT '置顶',
  `sortop` enum('n','y') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n' COMMENT '分类置顶',
  `hide` enum('n','y') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n' COMMENT '草稿y',
  `checked` enum('n','y') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'y' COMMENT '文章是否审核',
  `allow_remark` enum('n','y') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'y' COMMENT '允许评论y',
  `password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '访问密码',
  `template` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '模板',
  `tags` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL COMMENT '标签',
  `link` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '文章跳转链接',
  `feedback` varchar(2048) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'audit feedback',
  PRIMARY KEY (`gid`) USING BTREE,
  INDEX `author`(`author`) USING BTREE,
  INDEX `views`(`views`) USING BTREE,
  INDEX `comnum`(`comnum`) USING BTREE,
  INDEX `sortid`(`sortid`) USING BTREE,
  INDEX `top`(`top`, `date`) USING BTREE,
  INDEX `date`(`date`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Compact;

DROP TABLE IF EXISTS `{$db_prefix}blog_fields`;
CREATE TABLE `{$db_prefix}blog_fields`  (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `gid` bigint(20) UNSIGNED NOT NULL DEFAULT 0,
  `field_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT '',
  `field_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `gid`(`gid`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Compact;

DROP TABLE IF EXISTS `{$db_prefix}cart`;
CREATE TABLE `{$db_prefix}cart`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `is_local` tinyint(1) NULL DEFAULT 0 COMMENT '是否已本地身份加入购物车',
  `eb_local` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '本地身份标识',
  `user_id` int(10) NULL DEFAULT NULL COMMENT '用户ID',
  `goods_id` int(10) NULL DEFAULT NULL COMMENT '商品ID',
  `sku` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `quantity` int(10) NULL DEFAULT 0,
  `create_time` bigint(16) NULL DEFAULT NULL,
  `update_time` bigint(16) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Compact;

DROP TABLE IF EXISTS `{$db_prefix}comment`;
CREATE TABLE `{$db_prefix}comment`  (
  `cid` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '评论表',
  `gid` int(11) UNSIGNED NOT NULL DEFAULT 0 COMMENT '文章ID',
  `pid` int(11) UNSIGNED NOT NULL DEFAULT 0 COMMENT '父级评论ID',
  `top` enum('n','y') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n' COMMENT '置顶',
  `poster` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '发布人昵称',
  `uid` int(11) NOT NULL DEFAULT 0 COMMENT '发布人UID',
  `comment` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '评论内容',
  `mail` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'email',
  `url` varchar(75) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'homepage',
  `ip` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'ip address',
  `agent` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'user agent',
  `hide` enum('n','y') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n' COMMENT '是否审核',
  `date` bigint(20) NOT NULL COMMENT '创建时间',
  PRIMARY KEY (`cid`) USING BTREE,
  INDEX `gid`(`gid`) USING BTREE,
  INDEX `date`(`date`) USING BTREE,
  INDEX `hide`(`hide`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Compact;

DROP TABLE IF EXISTS `{$db_prefix}deliver`;
CREATE TABLE `{$db_prefix}deliver`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `order_id` int(10) NULL DEFAULT NULL,
  `order_list_id` int(10) NULL DEFAULT NULL,
  `content` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `create_time` bigint(16) NULL DEFAULT NULL,
  `delete_time` bigint(16) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `idx_deliver_order_list`(`order_list_id`, `delete_time`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Compact;

DROP TABLE IF EXISTS `{$db_prefix}goods`;
CREATE TABLE `{$db_prefix}goods`  (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `des` varchar(300) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '商品简介',
  `sort_num` int(10) NOT NULL DEFAULT 0 COMMENT '排序',
  `sort_top` tinyint(1) NOT NULL DEFAULT 0 COMMENT '分类置顶',
  `index_top` tinyint(1) NOT NULL DEFAULT 0 COMMENT '首页置顶',
  `type` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL,
  `attr_id` int(10) NULL DEFAULT NULL COMMENT '商品类型',
  `is_sku` varchar(5) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '是否是多规格',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '文章标题',
  `is_on_shelf` tinyint(1) NOT NULL DEFAULT 1,
  `attach_user` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '附加选项',
  `create_time` bigint(16) NOT NULL COMMENT '创建时间',
  `content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '文章内容',
  `pay_content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL,
  `cover` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '封面图',
  `sort_id` int(11) NOT NULL DEFAULT -1 COMMENT '分类ID',
  `sales` int(11) NULL DEFAULT 0 COMMENT '已售数量',
  `stock` int(10) NULL DEFAULT 0,
  `password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '访问密码',
  `template` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '模板',
  `tags` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL COMMENT '标签',
  `link` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '跳转链接',
  `delete_time` bigint(16) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `sortid`(`sort_id`) USING BTREE,
  INDEX `top`(`create_time`) USING BTREE,
  INDEX `date`(`create_time`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Compact;

DROP TABLE IF EXISTS `{$db_prefix}goods_type`;
CREATE TABLE `{$db_prefix}goods_type`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `delete_time` bigint(16) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Compact;

DROP TABLE IF EXISTS `{$db_prefix}link`;
CREATE TABLE `{$db_prefix}link`  (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '链接表',
  `sitename` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '名称',
  `siteurl` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '地址',
  `icon` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '图标URL',
  `description` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '备注信息',
  `hide` enum('n','y') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n' COMMENT '是否隐藏',
  `taxis` int(11) UNSIGNED NOT NULL DEFAULT 0 COMMENT '排序序号',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Compact;
INSERT INTO {$db_prefix}link (id, sitename, siteurl, icon, description, taxis) VALUES (1, '{$service_name}', '{$service_host}', '', '{$service_name}官方主页', 0);

DROP TABLE IF EXISTS `{$db_prefix}media_sort`;
CREATE TABLE `{$db_prefix}media_sort`  (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '资源分类表',
  `sortname` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '分类名',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Compact;

DROP TABLE IF EXISTS `{$db_prefix}member`;
CREATE TABLE `{$db_prefix}member`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Compact;

DROP TABLE IF EXISTS `{$db_prefix}member_price`;
CREATE TABLE `{$db_prefix}member_price`  (
  `goods_id` int(10) NOT NULL,
  `sku` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `member_level` tinyint(3) UNSIGNED NOT NULL,
  `price` bigint(16) NOT NULL
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci COMMENT = '会员价格表' ROW_FORMAT = Compact;

DROP TABLE IF EXISTS `{$db_prefix}navi`;
CREATE TABLE `{$db_prefix}navi`  (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '导航表',
  `naviname` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '导航名称',
  `url` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '导航地址',
  `newtab` enum('n','y') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n' COMMENT '在新窗口打开',
  `hide` enum('n','y') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n' COMMENT '是否隐藏',
  `taxis` int(11) UNSIGNED NOT NULL DEFAULT 0 COMMENT '排序序号',
  `pid` int(11) UNSIGNED NOT NULL DEFAULT 0 COMMENT '父级ID',
  `isdefault` enum('n','y') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n' COMMENT '是否系统默认导航，如首页',
  `type` tinyint(3) UNSIGNED NOT NULL DEFAULT 0 COMMENT '导航类型 0自定义 1首页 2微语 3后台管理 4分类 5页面',
  `type_id` int(11) UNSIGNED NOT NULL DEFAULT 0 COMMENT '导航类型对应ID',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Compact;
INSERT INTO {$db_prefix}navi (id, naviname, url, taxis, isdefault, type) VALUES (1, '首页', '', 1, 'y', 1);
INSERT INTO `{$db_prefix}navi` (id, `naviname`, url, `taxis`, `isdefault`, `type`) VALUES (2, '博客', 'blog', 1, 'y', 7);

DROP TABLE IF EXISTS `{$db_prefix}options`;
CREATE TABLE `{$db_prefix}options`  (
  `option_id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '站点配置信息表',
  `option_name` varchar(75) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '配置项',
  `option_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '配置项值',
  PRIMARY KEY (`option_id`) USING BTREE,
  UNIQUE INDEX `option_name_uindex`(`option_name`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 74 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Compact;
INSERT INTO {$db_prefix}options (option_name, option_value) VALUES 
('blogname','{$service_name}'),
('bloginfo','使用{$service_name}搭建的站点'),
('site_title',''),
('site_description',''),
('site_key','EM'),
('log_title_style','0'),
('blogurl','{$em_url}'),
('icp',''),
('footer_info','powered by <a href="{$service_host}">{$service_name}</a>'),
('rss_output_num','10'),
('rss_output_fulltext','y'),
('index_lognum','12'),
('isfullsearch','n'),
('index_comnum','10'),
('index_newlognum','5'),
('index_hotlognum','5'),
('comment_subnum','20'),
('nonce_templet','default'),
('admin_style','default'),
('tpl_sidenum','1'),
('comment_code','n'),
('comment_needchinese','n'),
('comment_interval',60),
('isgravatar','y'),
('isthumbnail','n'),
('att_maxsize','2048'),
('att_type','jpg,jpeg,png,gif,zip,rar'),
('att_imgmaxw','600'),
('att_imgmaxh','370'),
('comment_paging','y'),
('comment_pnum','10'),
('comment_order','newer'),
('iscomment','y'),
('login_comment','n'),
('ischkcomment','y'),
('isurlrewrite','0'),
('isalias','n'),
('isalias_html','n'),
('timezone','Asia/Shanghai'),
('active_plugins','$def_plugin'),
('widget_title','$widget_title'),
('custom_widget','a:0:{}'),
('widgets1','$def_widgets'),
('detect_url','y'),
('login_code','n'),
('email_code','n'),
('is_signup','y'),
('ischkarticle','y'),
('article_uneditable','n'),
('forbid_user_upload','n'),
('posts_per_day',10),
('smtp_mail',''),
('smtp_pw',''),
('smtp_server',''),
('smtp_port',''),
('is_openapi','n'),
('apikey','$apikey'),
('panel_menu_title',''),
('admin_article_perpage_num','10'),
('admin_user_perpage_num','20'),
('admin_comment_perpage_num','20'),
('home_bulletin','首页公告'),
('roll_bulletin','滚动公告'),
('sales_switch','y'),
('stock_switch','y'),
('order_email_switch','n'),
('order_pwd_switch','y'),
('order_tel_switch','n'),
('pay_redirect','list'),
('kami_order','asc'),
('login_switch','y'),
('register_switch','y'),
('balance_switch','y'),
('order_required', ''),
('register_email_switch', 'y'),
('register_tel_switch', 'y'),
('login_email_switch', 'y'),
('login_tel_switch', 'y'),
('mianze', '1');

DROP TABLE IF EXISTS `{$db_prefix}order`;
CREATE TABLE `{$db_prefix}order`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `client_ip` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '客户端ip',
  `user_id` int(10) NULL DEFAULT 0,
  `out_trade_no` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `tel` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `amount` int(10) NULL DEFAULT NULL,
  `create_time` bigint(16) NULL DEFAULT NULL,
  `payment` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '支付方式',
  `pay_plugin` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '支付插件',
  `pay_time` bigint(16) NULL DEFAULT NULL,
  `update_time` bigint(16) NULL DEFAULT NULL,
  `qr_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `expire_time` bigint(16) NULL DEFAULT NULL,
  `device` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `pay_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `pay_status` int(10) NULL DEFAULT 0,
  `delete_time` bigint(16) NULL DEFAULT NULL,
  `service_status` tinyint(1) NULL DEFAULT 0,
  `status` tinyint(1) NULL DEFAULT 0,
  `pwd` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `up_no` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Compact;

DROP TABLE IF EXISTS `{$db_prefix}order_list`;
CREATE TABLE `{$db_prefix}order_list`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `order_id` int(10) NULL DEFAULT NULL,
  `goods_id` int(10) NULL DEFAULT NULL,
  `sku` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `attr_spec` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `attach_user` varchar(800) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `quantity` int(10) NULL DEFAULT NULL,
  `unit_price` int(10) NULL DEFAULT NULL,
  `price` int(10) NULL DEFAULT NULL,
  `status` int(10) NULL DEFAULT 0 COMMENT '0:未发货，1:部分发货，2:全部发货',
  `cost_price` int(10) NULL DEFAULT 0,
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `order_id`(`order_id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Compact;

DROP TABLE IF EXISTS `{$db_prefix}order_required`;
CREATE TABLE `{$db_prefix}order_required`  (
  `order_id` int(10) NOT NULL,
  `name` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `content` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  INDEX `order_id`(`order_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Compact;

DROP TABLE IF EXISTS `{$db_prefix}sku_attr`;
CREATE TABLE `{$db_prefix}sku_attr`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `type_id` int(10) NULL DEFAULT NULL,
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `delete_time` bigint(16) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Compact;

DROP TABLE IF EXISTS `{$db_prefix}sku_value`;
CREATE TABLE `{$db_prefix}sku_value`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `attr_id` int(10) NULL DEFAULT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `delete_time` bigint(16) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Compact;

DROP TABLE IF EXISTS `{$db_prefix}skus`;
CREATE TABLE `{$db_prefix}skus`  (
  `code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `goods_id` int(10) NOT NULL COMMENT '商品id',
  `sku` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0' COMMENT '规格组合',
  `market_price` bigint(18) NULL DEFAULT NULL COMMENT '市场价',
  `cost_price` bigint(18) NULL DEFAULT NULL COMMENT '成本价',
  `guest_price` bigint(18) NULL DEFAULT NULL COMMENT '游客价格',
  `user_price` bigint(18) NULL DEFAULT NULL COMMENT '普通用户价格',
  `post_url` varchar(300) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `stock` int(10) NULL DEFAULT 0 COMMENT '库存',
  `sales` int(10) NULL DEFAULT 0 COMMENT '销量'
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Compact;

DROP TABLE IF EXISTS `{$db_prefix}sort`;
CREATE TABLE `{$db_prefix}sort`  (
  `sid` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '分类表',
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'goods',
  `sortname` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '分类名',
  `alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '别名',
  `taxis` int(11) UNSIGNED NOT NULL DEFAULT 0 COMMENT '排序序号',
  `pid` int(11) UNSIGNED NOT NULL DEFAULT 0 COMMENT '父分类ID',
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '备注',
  `kw` varchar(2048) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '关键词',
  `title` varchar(2048) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '页面标题',
  `template` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '分类模板',
  `sortimg` varchar(512) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '分类图像',
  `page_count` int(11) UNSIGNED NOT NULL DEFAULT 0 COMMENT '每页文章数量',
  PRIMARY KEY (`sid`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Compact;

DROP TABLE IF EXISTS `{$db_prefix}stock`;
CREATE TABLE `{$db_prefix}stock`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL,
  `goods_id` int(10) NOT NULL,
  `sku` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `content` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL,
  `create_time` bigint(16) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Compact;

DROP TABLE IF EXISTS `{$db_prefix}storage`;
CREATE TABLE `{$db_prefix}storage`  (
  `sid` int(8) NOT NULL AUTO_INCREMENT COMMENT '对象存储表',
  `plugin` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '插件名',
  `name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '对象名',
  `type` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '对象数据类型',
  `value` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '对象值',
  `createdate` int(11) NOT NULL COMMENT '创建时间',
  `lastupdate` int(11) NOT NULL COMMENT '更新时间',
  PRIMARY KEY (`sid`) USING BTREE,
  UNIQUE INDEX `plugin`(`plugin`, `name`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Compact;

DROP TABLE IF EXISTS `{$db_prefix}tag`;
CREATE TABLE `{$db_prefix}tag`  (
  `tid` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '标签表',
  `tagname` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '标签名',
  `description` varchar(2048) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '页面描述',
  `title` varchar(2048) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '页面标题',
  `kw` varchar(2048) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '关键词',
  `gid` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '文章ID',
  PRIMARY KEY (`tid`) USING BTREE,
  INDEX `tagname`(`tagname`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Compact;

DROP TABLE IF EXISTS `{$db_prefix}tpl_options_data`;
CREATE TABLE `{$db_prefix}tpl_options_data`  (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `template` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `depend` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `template`(`template`, `name`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Compact;

DROP TABLE IF EXISTS `{$db_prefix}twitter`;
CREATE TABLE `{$db_prefix}twitter`  (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '微语笔记表',
  `content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '微语内容',
  `img` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '图片',
  `author` int(11) NOT NULL DEFAULT 1 COMMENT '作者UID',
  `date` bigint(20) NOT NULL COMMENT '创建时间',
  `replynum` int(11) UNSIGNED NOT NULL DEFAULT 0 COMMENT '回复数量',
  `private` enum('n','y') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n' COMMENT '是否私密',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `author`(`author`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Compact;

DROP TABLE IF EXISTS `{$db_prefix}user`;
CREATE TABLE `{$db_prefix}user`  (
  `uid` int(11) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '用户表',
  `expend` decimal(10, 2) NULL DEFAULT 0.00 COMMENT '总消费',
  `username` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '用户名',
  `password` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '用户密码',
  `money` decimal(10, 2) NULL DEFAULT 0.00 COMMENT '用户余额',
  `nickname` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '昵称',
  `level` tinyint(1) NULL DEFAULT 0 COMMENT '用户等级',
  `role` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '用户组',
  `ischeck` enum('n','y') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'n' COMMENT '内容是否需要管理员审核',
  `photo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '头像',
  `email` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '邮箱',
  `tel` varchar(11) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '手机号码',
  `description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT '备注',
  `ip` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'ip地址',
  `reg_ip` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '注册IP',
  `state` tinyint(4) NOT NULL DEFAULT 0 COMMENT '用户状态 0正常 1禁用',
  `credits` int(11) UNSIGNED NOT NULL DEFAULT 0 COMMENT '用户积分',
  `create_time` int(11) NOT NULL COMMENT '创建时间',
  `update_time` int(11) NOT NULL COMMENT '更新时间',
  PRIMARY KEY (`uid`) USING BTREE,
  INDEX `username`(`username`) USING BTREE,
  INDEX `email`(`email`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci ROW_FORMAT = Compact;
INSERT INTO {$db_prefix}user (uid, username, email, password, nickname, role, create_time, update_time) VALUES (1,'$username','$email','$password', '管理员','admin', {$timestamp}, {$timestamp});
sql;



    $array_sql = preg_split("/;[\r\n]/", $sql);
    foreach ($array_sql as $sql) {
        $sql = trim($sql);
        if ($sql) {
            $DB->query($sql);
        }
    }
    $CACHE->updateCache();
    $result = '';
    $result .= "
        <p style=\"font-size:24px; border-bottom:1px solid #E6E6E6; padding:10px 0px;\">安装成功了🎉</p>
        <p><b>用户名</b>：{$username}</p>
        <p><b>密 码</b>：刚才设定的密码</p>";
    if ($env_em_env === 'develop' || ($env_em_env !== 'develop' && !@unlink('./install.php'))) {
        $result .= '<p style="color:#ff0000;margin:10px 20px;">警告：请手动删除根目录下安装文件：install.php</p> ';
    }
    $result .= "<p style=\"text-align:right;\"><a href=\"./\">访问首页</a> | <a href=\"./admin/\">登录后台</a></p>";
    emMsg($result, 'none');
}
?>