<?php defined('EM_ROOT') || exit('access denied!'); ?>
<?php $mianze_date = strtotime(date('2025-10-25 01:12:00')) ?>
<style>
    /* 现代卡片样式 */
    .auth-card {
        border-radius: 12px;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
        overflow: hidden;
    }


    /* 渐变标题栏（改为蓝紫色调） */
    .auth-header {
        background: linear-gradient(135deg, #4F63EB 0%, #6C5CE7 100%);
        color: white;
        padding: 18px 24px;
        font-size: 18px;
        font-weight: 500;
    }

    /* 内容区域优化 */
    .auth-body {
        padding: 28px 24px;
    }
    .intro-text {
        font-size: 16px;
        color: #4A5568; /* 深灰色文字，提升可读性 */
        line-height: 1.6;
        margin-bottom: 24px;
    }

    /* 功能列表美化（调整图标颜色） */
    .feature-list {
        margin-bottom: 30px;
        padding-left: 0;
    }
    .feature-item {
        list-style: none;
        padding: 12px 0;
        padding-left: 32px;
        position: relative;
        border-bottom: 1px dashed #EDF2F7;
        color: #4A5568;
        transition: color 0.2s ease;
    }
    .feature-item:last-child {
        border-bottom: none;
    }
    .feature-item:before {
        content: "✓";
        position: absolute;
        left: 0;
        top: 12px;
        width: 20px;
        height: 20px;
        border-radius: 50%;
        background: #38B2AC; /* 青绿色对勾，清新且不刺眼 */
        color: white;
        font-size: 12px;
        text-align: center;
        line-height: 20px;
    }
    .feature-item:hover {
        color: #38B2AC;
    }

    /* 按钮样式优化（匹配主色调） */
    .btn-group {
        display: flex;
        gap: 16px;
    }
    .layui-btn-primary-2 {
        background: #F7FAFC;
        color: #4A5568;
        border: none;
        padding: 0 24px;
        height: 42px;
        border-radius: 6px;
        transition: all 0.2s ease;
    }
    .layui-btn-primary-2:hover {
        background: #EDF2F7;
    }
    .primary-btn {
        background: #4F63EB;
        color: white;
        border: none;
        padding: 0 24px;
        height: 42px;
        border-radius: 6px;
        transition: all 0.2s ease;
    }
    .primary-btn:hover {
        background: #434190;
        box-shadow: 0 4px 12px rgba(79, 99, 235, 0.2);
    }
    .primary-btn i {
        margin-left: 8px;
    }
</style>

<style>

    .layui-card-header{
        border-bottom-color: #eee;
    }
    .layui-card-footer{
        padding: 10px 15px;
        border-top: 1px solid #eee;
    }
    .font-strong{
        font-weight: bold;
        font-size: 30px;
        height: 49px;
        line-height: 49px;
    }


</style>



<?php doAction('adm_main_top') ?>


<div class="">
    <div class="grid-cols-xs-2 grid-cols-sm-2 grid-cols-xl-5 grid-cols-lg-3 grid-cols-md-3  mb-3 grid-gap-10" style="width: 100%;">
        <div class="layui-card">
            <div class="layui-card-header" style="display: flex; justify-content: space-between;">
                <span>系统版本</span>
                <span>
                    <?php if (!Register::isRegLocal()) : ?>
                        <a style="float: right;" href="<?= SERVICE_HOST ?>/index/register/index" target="_blank"><span class="label ">未授权</span></a>
                    <?php else: ?>
                        <?php if (Register::getRegType() == 2): ?>
                            <span class="layui-badge layui-bg-orange">SVIP</span>
                        <?php elseif (Register::getRegType() == 1): ?>
                            <a style="float: right;" href="<?= SERVICE_HOST ?>/index/register/index" target="_blank" class="label success">VIP</a>
                        <?php else: ?>
                            <a style="float: right;" href="<?= SERVICE_HOST ?>/index/register/index" target="_blank" class="label primary">已授权</a>
                        <?php endif ?>
                    <?php endif; ?>
                </span>
            </div>
            <div class="layui-card-body">
                <p class="info mt-5 font-strong">v<?= ucfirst(Option::EM_VERSION) ?></p>
                <div class="pb-3 mt-2"><?= SERVICE_NAME ?></div>
            </div>
            <div class="layui-card-footer" style="display: flex; justify-content: space-between;">
                <span>检查新版本</span>
                <span id="check-update">
                    <button type="button" onclick="checkUpdate()" class="layui-btn  layui-btn-primary layui-btn-xs layui-border-blue">检查更新</button>
                </span>

            </div>
        </div>
        <?php if(Option::get('mianze') > $mianze_date): ?>
        <div class="layui-card">
            <div class="layui-card-header" style="display: flex; justify-content: space-between;">
                <span>用户协议</span>
                <span class="layui-badge layui-bg-green">同意</span>
            </div>
            <div class="layui-card-body">
                <p class="info mt-5 font-strong" style="font-weight: 500; font-size: 20px;"><?= date('Y-m-d', Option::get('mianze')) ?></p>
                <div class="pb-3 mt-2">签署日期</div>
            </div>
            <div class="layui-card-footer" style="display: flex; justify-content: space-between;">
                <span>查看协议</span>
                <span><button type="button" id="chakan-mianze" class="layui-btn  layui-btn-primary layui-btn-xs layui-border-blue">点击查看</button></span>
            </div>
        </div>
        <?php endif; ?>


        <div class="layui-card">
            <div class="layui-card-header" style="display: flex; justify-content: space-between;">
                <span>客单价</span>
                <span class="layui-badge layui-bg-green">今日</span>
            </div>
            <div class="layui-card-body">
                <p class="info mt-5 font-strong">
                    <?= empty($today_sales_amount) || empty($order_panel['today_orders']) ? number_format(0, 2) : number_format($today_sales_amount / $order_panel['today_orders'], 2) ?>
                </p>
                <div class="pb-3 mt-2">
                    昨日 <?= empty($yesterday_sales_amount) || empty($order_panel['yesterday_orders']) ? number_format(0, 2) : number_format($yesterday_sales_amount / $order_panel['yesterday_orders'], 2) ?> 元
                </div>
            </div>
            <div class="layui-card-footer" style="display: flex; justify-content: space-between;">
                <span>本月客单价</span>
                <span>
                    <?= empty($current_month_sales_amount) || empty($order_panel['month_orders']) ? number_format(0, 2) : number_format($current_month_sales_amount / $order_panel['month_orders'], 2) ?> 元
                </span>
            </div>
        </div>
        <div class="layui-card" style="margin-bottom: 15px;">
            <div class="layui-card-header" style="display: flex; justify-content: space-between;">
                <span>新增用户</span>
                <span class="layui-badge layui-bg-green">今日</span>
            </div>
            <div class="layui-card-body">
                <p class="info mt-5 font-strong"><?= $user_panel['today_registrations'] ?></p>
                <div class="pb-3 mt-2">昨日 <?= $user_panel['yesterday_registrations'] ?> 人</div>
            </div>
            <div class="layui-card-footer" style="display: flex; justify-content: space-between;">
                <span>本月新增用户</span>
                <span><?= $user_panel['month_registrations'] ?> 人</span>
            </div>
        </div>
    </div>




</div>



<div class="mt-4 shadow-lg">
    <?php if (User::isAdmin()): ?>
        <?php if (!Register::isRegLocal()) : ?>

            <div style="margin-top: 20px;">
                <!-- 公告卡片 -->
                <div class="layui-card auth-card">
                    <!-- 标题栏 -->
                    <div class="layui-card-header auth-header">
                        <i class="layui-icon layui-icon-notice" style="margin-right: 10px; font-size: 20px;"></i>
                        系统授权提示
                    </div>

                    <!-- 内容区域 -->
                    <div class="layui-card-body auth-body">
                        <p class="intro-text">
                            您安装的<?= SERVICE_NAME ?>尚未授权，完成授权可使用全部功能，包括如下：
                        </p>

                        <!-- 功能列表 -->
                        <ul class="feature-list">
                            <li class="feature-item">
                                解锁在线升级功能，一键升级到最新版本，获得来自官方的安全和功能更新
                            </li>
                            <li class="feature-item">
                                解锁应用商店，获得更多模板和插件，并支持应用在线一键更新
                            </li>
                            <li class="feature-item">
                                去除所有未注册提示及功能限制，加入专属Q群，获得官方技术指导问题解答
                            </li>
                        </ul>

                        <!-- 操作按钮 -->
                        <div class="btn-group">
                            <a style="line-height: 42px; font-size: 15px;" class="layui-btn  layui-btn-primary layui-btn-primary-2" href="auth.php">
                                去授权
                            </a>
                            <a style="line-height: 42px; font-size: 15px;" class="layui-btn primary-btn layui-btn-primary-2"  href="<?= SERVICE_HOST ?>/index/register/index" target="_blank">
                                获取授权码
                                <i class="layui-icon layui-icon-right"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif ?>




    <?php endif ?>
</div>



<?php if (User::isAdmin()): ?>
        <?php doAction('adm_main_content') ?>
<?php endif; ?>

<script>
    $('#chakan-mianze').click(function(){
        let isMobile = window.innerWidth < 768;
        let area = isMobile ? ['98%', 'auto']  : ['700px', 'auto'];
        layer.open({
            type: 2,
            id: 'xieyi',
            title: "EMSHOP商城用户协议",
            area: area,
            closeBtn: true,
            maxmin: true,
            content: 'index.php?action=mianze&chakan=1',
            shadeClose: true,
            scrollbar: false,
            skin: 'layui-layer-molv',
            fixed: false, // 不固定
            success: function(layero, index, that){
                layer.iframeAuto(index); // 让 iframe 高度自适应
                that.offset(); // 重新自适应弹层坐标
            }
        });
    })



</script>


<?php if(Option::get('mianze') < $mianze_date): ?>
<script>

    let isMobile = window.innerWidth < 768;
    let area = isMobile ? ['98%', 'auto']  : ['700px', 'auto'];
    layer.open({
        type: 2,
        title: "EMSHOP商城用户协议",
        area: area,
        closeBtn: false,
        content: 'index.php?action=mianze',
        shadeClose: false,
        scrollbar: false,
        skin: 'layui-layer-molv',
        fixed: false, // 不固定
        success: function(layero, index, that){
            layer.iframeAuto(index); // 让 iframe 高度自适应
            that.offset(); // 重新自适应弹层坐标
        }
    });


</script>
<?php endif; ?>


<script>


    function checkUpdate() {

        loadIndex = layer.load(2);

        $.get("./upgrade.php?action=check_update", function (result) {
            layer.close(loadIndex);
            if (result.code === 1001) {
                layer.msg('未授权程序禁止在线更新');
            } else if (result.code === 1002) {
                layer.msg('好兄弟，我知道你很急，但是你先别急。当前已是最新版本');
            } else if (result.code === 200) {
                layer.msg("发现新版本");
                rep_content = "";

                console.log(result.data.list)
                // 循环遍历每个版本
                result.data.list.forEach(item => {
                    rep_content += `<div style="margin-bottom: 20px; font-size: 16px; text-align: center; margin-top: 10px;">有可用的新版本：<span class="text-danger">${item.version}</span></div>`;
                    rep_content += `<div><b>更新内容</b>:<br>${item.content}</div>`;
                });
                // 检查 cdn_sql 和 cdn_file 是否为空
                let sqlFile = result.data.cdn_sql || result.data.sql;
                let fileFile = result.data.cdn_file || result.data.file;

                let isMobile = window.innerWidth < 768;
                let area = isMobile ? ['98%', '70%']  : ['500px', 'auto'];

                layer.alert(rep_content, {
                    btn: ['点击更新'],
                    btnAlign: 'c', // 按钮居中显示
                    area: area,
                    scrollbar: false,
                    title: '发现新版本',
                    btn1: function(){
                        loadIndex = layer.load(2);
                        $.get(`./upgrade.php?action=update&source=${fileFile}&upsql=${sqlFile}`, function (data) {
                            layer.close(loadIndex);
                            if (data.includes("succ")) {
                                layer.alert('🎉恭喜，更新成功了🎉，<a href="./">刷新页面</a> 开始体验新版本', {
                                    btn: ['刷新页面'],
                                    btnAlign: 'c', // 按钮居中显示
                                    scrollbar: false,
                                    title: '更新成功',
                                    btn1: function(){
                                        location.reload();
                                    }
                                });
                            } else if (data.includes("error_down")) {
                                layer.alert('下载更新失败，可能是服务器网络问题');
                            } else if (data.includes("error_zip")) {
                                layer.alert('解压更新失败，可能是你的服务器空间不支持zip模块');
                            } else if (data.includes("error_dir")) {
                                layer.alert('更新失败，目录不可写');
                            } else if (data.includes('noRegister')){
                                layer.alert('未授权版本不支持在线更新！');
                            }else {
                                layer.alert('更新失败');
                            }
                        });
                    }
                });

            } else {
                layer.msg("检查更新请求失败，可能是网络问题");
            }

        });
    }

    function doUp(source, upSQL) {
        const updateModalLoading = $("#update-modal-loading");
        const updateModalMsg = $("#update-modal-msg");
        const updateModalChanges = $("#update-modal-changes");
        const upmsg = $("#upmsg");
        const upbtn = $("#upbtn");

        updateModalLoading.addClass("spinner-border text-primary");
        updateModalMsg.html("更新中... 请耐心等待");
        updateModalChanges.html("");

        $.get(`./upgrade.php?action=update&source=${source}&upsql=${upSQL}`, function (data) {
            upmsg.removeClass();
            if (data.includes("succ")) {
                upbtn.text('刷新页面');
                upbtn.attr('href', './');
                updateModalMsg.html('🎉恭喜，更新成功了🎉，<a href="./">刷新页面</a> 开始体验新版本');
            } else if (data.includes("error_down")) {
                updateModalMsg.html('下载更新失败，可能是服务器网络问题');
            } else if (data.includes("error_zip")) {
                updateModalMsg.html('解压更新失败，可能是你的服务器空间不支持zip模块');
            } else if (data.includes("error_dir")) {
                updateModalMsg.html('更新失败，目录不可写');
            } else if (data.includes('noRegister')){
                updateModalMsg.html('未授权版本不支持在线更新！');
            }else {
                updateModalMsg.html('更新失败');
            }
            updateModalLoading.removeClass();
        });
    }


    $("#menu-dashboard").addClass('active');

    $.get("./upgrade.php?action=check_update", function (result) {
        if (result.code === 200) {
            $('#check-update-btn').addClass('danger');
            $('#check-update-btn').html('点击更新 v' + result.data.list[0].version);
            $('#check-update').html(`<button type="button" onclick="checkUpdate()" class="layui-btn  layui-btn-primary layui-btn-xs layui-border-red">发现新版本</button>`);
        }
    });
</script>