<?php
/*
Plugin Name: 商品类型【虚拟服务】
Version: 1.0.1
Plugin URL:
Description: 创建虚拟服务类型的商品，适合用于需要人工发货的商品
Author: 驳手
Author URL:
Ui: Layui
*/

defined('EM_ROOT') || exit('access denied!');

// 添加商品类型
function plugin_goods_service_type($goods, &$result){
    $goods['goods_type_all'][] = ['name' => '虚拟服务（新）', 'value' => 'service'];
    $result = $goods;
}

// 展示商品列表的商品类型徽章
function plugin_goods_list_type_service($type){
    echo <<<html
{{#  if(d.type == 'service'){ }}
<span class="layui-badge layui-bg-red">新虚拟服务</span>
{{#  } }}
html;
}

// 发货
function plugin_goods_service_deliver($db, $db_prefix, $goods, $order, $order_child){
    if($goods['type'] == 'service'){
        $sku = empty($order_child['sku']) ? '0' : $order_child['sku'];
        // 查询出库存表里的卡密
        $stock = $db->once_fetch_array("SELECT * FROM {$db_prefix}goods_service WHERE goods_id = {$order_child['goods_id']} AND sku = '{$sku}'");
        // 将查询出的卡密写入到发货表里
        $timestamp = time();
        $db->query("INSERT INTO {$db_prefix}goods_service_sale 
    (goods_id, order_list_id, sku, content, num, create_time) 
VALUES ({$order_child['goods_id']}, {$order_child['id']}, '{$sku}', '{$stock['content']}', {$order_child['quantity']}, $timestamp)");

        // 更新订单状态
        $db->query("UPDATE {$db_prefix}order SET status = 1 WHERE id = '{$order['id']}'");
    }
}

// 未售库存页面
function plugin_goods_service_stock_ws($goods, &$result){
    if($goods['type'] == 'service'){
        $goods['stock_page'] = "../../content/plugins/goods_service/goods_service_show";
        $result = $goods;
    }

}
// 已售库存页面
function plugin_goods_service_stock_ys($goods, &$result){
    if($goods['type'] == 'service'){
        $goods['stock_page'] = "../../content/plugins/goods_service/goods_service_show";
        $result = $goods;
    }

}

// 订单列表按钮
function plugin_goods_service_user_order_list_btn($order, $child_order){
    if($child_order['type'] == 'service'){
        if(!empty($order['pay_time'])){
            echo <<<html
<a href="?action=sdk&out_trade_no={$order['out_trade_no']}" class="btn btn-sm btn-primary">
    <i class="fas fa-key mr-1"></i> 查看订单详情
</a>
<a href="{$child_order['goods_url']}" class="btn btn-sm btn-outline-secondary ml-2">再次购买</a>
html;

        }
    }
}
// 显示订单详情页
function plugin_goods_service_view_order_detail($db, $db_prefix, $goods, $order, $child_order){
    if($goods['type'] == 'service'){
        $msg = $db->once_fetch_array("select * from {$db_prefix}goods_service_sale where order_list_id = {$child_order['id']} and is_default = 'y'");
        $kami = $db->once_fetch_array("select * from {$db_prefix}goods_service_sale where order_list_id = {$child_order['id']} and is_default = 'n'");

        include View::getUserView('header');
        include EM_ROOT . "/content/plugins/goods_service/order_detail.php";
        include View::getUserView('footer');
        View::output();
    }
}

// 后台发货页面
function plugin_goods_service_adm_deliver_view($db, $db_prefix, $goods, $order, $child_order){
    if($goods['type'] == 'service'){
        include View::getAdmView('open_head');
        require_once EM_ROOT . "/content/plugins/goods_service/adm_deliver_view.php";
        include View::getAdmView('open_foot');
        View::output();

    }
}

// 获取发货内容
function plugin_goods_service_adm_order_detail($db, $db_prefix, $goods, $child_order){
//    d($data);die;
    if($goods['type'] == 'service'){
        $sale = $db->once_fetch_array("select * from {$db_prefix}goods_service_sale where order_list_id = {$child_order['id']} and is_default = 'n'");
        return empty($sale) ? '无' : $sale['content'];
    }
}

function plugin_goods_service_home_goods_list($goods, &$result){
    foreach($goods as $key => $val){
        if($val['type'] == 'service'){
            $goods[$key]['type_text_badge'] = '<span class="badge badge-danger">人工发货</span>';
        }
    }
    $result = $goods;
}

function plugin_goods_service_goods_content_echo($goods, &$result){
    if($goods['type'] == 'service'){
        $goods['type_text_badge'] = '<span class="badge badge-danger">人工发货</span>';
    }
    $result = $goods;
}

addAction('adm_add_goods_goodsinfo', 'plugin_goods_service_type');
addAction('adm_goods_list_type', 'plugin_goods_list_type_service');
addAction('adm_stock_page_ws', 'plugin_goods_service_stock_ws');
addAction('adm_stock_page_ys', 'plugin_goods_service_stock_ys');
addAction('deliver', 'plugin_goods_service_deliver');
addAction('user_order_list_btn', 'plugin_goods_service_user_order_list_btn');
addAction('view_order_detail', 'plugin_goods_service_view_order_detail');
addAction('adm_deliver_view', 'plugin_goods_service_adm_deliver_view');
addAction('home_goods_list', 'plugin_goods_service_home_goods_list');
addAction('goods_content_echo', 'plugin_goods_service_goods_content_echo');